<?php

function code_snippet_manager_enqueue_frontend_scripts() {
    if (is_admin() || wp_doing_ajax() || !is_main_query()) {
        return;
    }

    // Obtener los snippets
    $snippets = array_merge(
        get_posts(['post_type' => 'css_snippet', 'posts_per_page' => -1]),
        get_posts(['post_type' => 'js_snippet', 'posts_per_page' => -1])
    );

    // Obtener tipo de post y ID actuales
    $current_post_type = get_post_type();
    $current_post_id = get_queried_object_id();

    foreach ($snippets as $snippet) {
        // Obtener ubicaciones y exclusiones, asegurarse de que sean arrays
        $location = get_post_meta($snippet->ID, '_code_snippet_location_include', true);
        $exclude_location = get_post_meta($snippet->ID, '_code_snippet_exclude_location', true);

        $apply_snippet = false;
        $omit_snippet = false;

        // Asegurarse de que location y exclude_location sean arrays
        $location = is_array($location) ? $location : [];
        $exclude_location = is_array($exclude_location) ? $exclude_location : [];

        /** Verificar exclusión primero **/
        foreach ($exclude_location as $exclude) {
            if ($exclude === 'all') {
                $omit_snippet = true;
                break;
            } elseif ($exclude === 'pages' && is_page()) {
                $omit_snippet = true;
                break;
            } elseif ($exclude === 'home' && is_front_page()) {  // Validación para la Home Page
                $omit_snippet = true;
                break;
            } elseif (strpos($exclude, 'post_type_') === 0) {
                $post_type = substr($exclude, 10);
                $omit_snippet = ($current_post_type === $post_type);
                if ($omit_snippet) break;
            } elseif (strpos($exclude, 'post_') === 0) {
                $post_id = substr($exclude, 5);
                $omit_snippet = ($current_post_id == $post_id);
                if ($omit_snippet) break;
            }
        }

        /** Verificar inclusión solo si no se excluye **/
        if (!$omit_snippet) {
            foreach ($location as $loc) {
                if ($loc === 'all') {
                    $apply_snippet = true;
                    break;
                } elseif ($loc === 'pages' && is_page()) {
                    $apply_snippet = true;
                    break;
                } elseif ($loc === 'home' && is_front_page()) {  // Validación para la Home Page
                    $apply_snippet = true;
                    break;
                } elseif (strpos($loc, 'post_type_') === 0) {
                    $post_type = substr($loc, 10);
                    $apply_snippet = ($current_post_type === $post_type);
                    if ($apply_snippet) break;
                } elseif (strpos($loc, 'post_') === 0) {
                    $post_id = substr($loc, 5);
                    $apply_snippet = ($current_post_id == $post_id);
                    if ($apply_snippet) break;
                }
            }
        }


        /** Encolar si aplica y no está excluido **/
        if ($apply_snippet && !$omit_snippet) {
            $code_content = get_post_meta($snippet->ID, '_code_snippet_content', true);
            $snippet_title = sanitize_title($snippet->post_title); // Sanitizar título del post
            $attributes = get_post_meta($snippet->ID, '_code_snippet_attributes', true);
            $attributes = trim($attributes);
            $attributes = $attributes ? ' ' . $attributes : '';
            if ($snippet->post_type === 'css_snippet' && $code_content) {
                $style_id = 'custom-css-snippet-' . $snippet->ID . '-' . $snippet_title;

                add_action('wp_head', function() use ($code_content, $style_id, $attributes) {
                    echo "<style id='{$style_id}' type='text/css'{$attributes}>\n" . $code_content . "\n</style>";
                }, 999);
                
            } elseif ($snippet->post_type === 'js_snippet' && $code_content) {
                $snippet_position = get_post_meta($snippet->ID, '_code_snippet_position', true);
                $script_id = 'custom-js-snippet-' . $snippet->ID . '-' . $snippet_title;

                $output_function = function() use ($script_id, $code_content, $attributes) {
                    echo "<script id='{$script_id}' type='text/javascript'{$attributes}>\n" . $code_content . "\n</script>";
                };

                if ($snippet_position === 'footer') {
                    add_action('wp_footer', $output_function, 999);
                } else {
                    add_action('wp_head', $output_function, 999);
                }
            }
}

    }
}

// Encolar scripts solo en el frontend
if (!is_admin()) {
    add_action('wp_enqueue_scripts', 'code_snippet_manager_enqueue_frontend_scripts');
}
